/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>

 * does not use built-in detection function.  base rule --
 * alert tcp $EXTERNAL_NET $HTTP_PORTS -> $HOME_NET any (msg:"WEB-CLIENT Microsoft
 * mp3 malformed APIC header RCE attempt"; flow: to_client, established; flowbits:
 * isset, mp3.download; content:"APIC"; byte_test: 1, =, 1, 6, relative;
 * content:"|00|"; distance: 0; content:"|00 00|"; distance: 0;
 * reference:url,technet.microsoft.com/en-us/security/bulletin/ms09-047;
 * reference: cve, 2009-2499; classtype: attempted-user; 
 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_WRAP(code) code
#else
#define DEBUG_WRAP(code)
#endif

/* declare detection functions */
int rule15920eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_client; */
static FlowFlags rule15920flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule15920option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule15920flow0
    }
};
/* flowbits:isset "file.mp3"; */
static FlowBitsInfo rule15920flowbits1 =
{
    "file.mp3",
    FLOWBIT_ISSET,
    0,
};

static RuleOption rule15920option1 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule15920flowbits1
    }
};
// content:"APIC", depth 0; 
static ContentInfo rule15920content2 = 
{
    (uint8_t *) "APIC", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED|CONTENT_FAST_PATTERN, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule15920option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule15920content2
    }
};
/* byte_test:size 1, value 1, offset 6, relative; */
static ByteData rule15920byte_test3 = 
{
    1, /* size */
    CHECK_EQ, /* operator */
    1, /* value */
    6, /* offset */
    0, /*multiplier */
    BYTE_BIG_ENDIAN|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE /* flags */
};

static RuleOption rule15920option3 = 
{
    OPTION_TYPE_BYTE_TEST,
    {
        &rule15920byte_test3
    }
};

// content:"|00|", depth 0, relative; 
static ContentInfo rule15920content4 = 
{
    (uint8_t *) "|00|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule15920option4 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule15920content4
    }
};
#ifndef CONTENT_FAST_PATTERN
#define CONTENT_FAST_PATTERN 0
#endif
// content:"|00 00|", depth 0, relative; 
static ContentInfo rule15920content5 = 
{
    (uint8_t *) "|00 00|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule15920option5 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule15920content5
    }
};

/* references for sid 15920 */
/* reference: cve "2009-2499"; */
static RuleReference rule15920ref1 = 
{
    "cve", /* type */
    "2009-2499" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS09-047"; */
static RuleReference rule15920ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS09-047" /* value */
};

static RuleReference *rule15920refs[] =
{
    &rule15920ref1,
    &rule15920ref2,
    NULL
};
/* metadata for sid 15920 */
/* metadata: service http, policy balanced-ips drop, policy security-ips drop; */

static RuleMetaData rule15920service1 =
{
    "service http"
};


//static RuleMetaData rule15920policy1 =
//{
//    "policy balanced-ips drop"
//};
//
//static RuleMetaData rule15920policy2 =
//{
//    "policy security-ips drop"
//};

static RuleMetaData rule15920policy3 =
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule15920metadata[] =
{
    &rule15920service1,
//    &rule15920policy1,
//    &rule15920policy2,
    &rule15920policy3,
    NULL
};

RuleOption *rule15920options[] =
{
    &rule15920option0,
    &rule15920option1,
    &rule15920option2,
    &rule15920option3,
    &rule15920option4,
    &rule15920option5,
    NULL
};

Rule rule15920 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "$HTTP_PORTS", /* SRCPORT   */
   
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
   
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       15920, /* sigid */
       9, /* revision */
   
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "FILE-MULTIMEDIA Microsoft mp3 malformed APIC header RCE attempt",     /* message */
       rule15920refs /* ptr to references */
       ,rule15920metadata
   },
   rule15920options, /* ptr to rule options */
   &rule15920eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule15920eval(void *p) {
    const uint8_t *cursor_normal = 0, *beg_of_payload, *end_of_payload, *startOfData;
    SFSnortPacket *sp = (SFSnortPacket *) p;

    uint32_t frameSize;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flow:established, to_client;
    if (checkFlow(p, rule15920options[0]->option_u.flowFlags) > 0 ) {
        // flowbits:isset "file.mp3";
        if (processFlowbits(p, rule15920options[1]->option_u.flowBit) > 0) {
            // content:"APIC", depth 0;
            if (contentMatch(p, rule15920options[2]->option_u.content, &cursor_normal) > 0) {

                DEBUG_WRAP(printf("found APIC\n"));
                // byte_test:size 1, value 1, offset 6, relative;
                if (byteTest(p, rule15920options[3]->option_u.byte, cursor_normal) > 0) {

                    DEBUG_WRAP(printf("passed byte_test\n"));
                    if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
                        return RULE_NOMATCH;

                    if (cursor_normal + 9 >= end_of_payload){
                        return RULE_NOMATCH;
                    }

                    frameSize = *cursor_normal++ << 24;
                    frameSize |= *cursor_normal++ << 16;
                    frameSize |= *cursor_normal++ << 8;
                    frameSize |= *cursor_normal++;


                    DEBUG_WRAP(printf("frameSize=0x%08x (%d)\n", frameSize, frameSize));

                    // Set cursor to the location of TextEncoding
                    cursor_normal += 2;
                    startOfData = cursor_normal;

                    // We are searching for a NULL in null-terminated data
                    // content:"|00|", depth 0, relative;
                    if (contentMatch(p, rule15920options[4]->option_u.content, &cursor_normal) > 0) {

                        // Skip the "Picture Type" field
                        cursor_normal++;

                        // We are searching for a double-NULL in a unicode string
                        // content:"|00 00|", depth 0, relative;
                        if (contentMatch(p, rule15920options[5]->option_u.content, &cursor_normal) > 0) {

                           if(cursor_normal - startOfData > frameSize) {
                                  return RULE_MATCH;
                           } 

                        } else { // Ran out of data, see if we should have seen end of frame already

                            if(end_of_payload - startOfData > frameSize){
                                return RULE_MATCH;
                            }

                        }
                    }
                }
            }
        }
    }
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule15920,
    NULL
};
*/
